init -2 python:
    def get_need_xp(level):
        return level * 98

    def check_level():
        global MC_Exp, needxp, MC_Lvl, sp_available, ap_available, ap_available_cur, tp_available, tp_available_cur, MC_Max_HP

        leveled = False
        
        MC_Max_HP = 150 + MC_Lvl * 5 + MC_Body * 5

        while MC_Exp >= needxp:
            MC_Exp -= needxp
            MC_Lvl += 1

            # Каждые 5 уровней → 1 очко способностей
            if MC_Lvl % 5 == 0:
                sp_available += 1


            if MC_Lvl % 3 == 0:
                tp_available += 1
                tp_available_cur += 1

            # Апгрейд по уровням
            ap_available += 3
            ap_available_cur += 3

            needxp = get_need_xp(MC_Lvl)
            leveled = True

        if leveled:
            renpy.notify("Level up: " + str(MC_Lvl))




    if "level_daemon" not in config.overlay_screens:
        config.overlay_screens.append("level_daemon")


screen level_daemon():
    # Невидимый экран; таймер дёргает функцию регулярно
    timer 5.0 action Function(check_level) repeat True







screen game_icons:


    vbox xalign 1.0 yalign 0.5:

        imagebutton:
            idle "images/icons/char.png" at shrink_small
            hover im.MatrixColor('images/icons/char.png', im.matrix.brightness(0.2))
            action [
                SetVariable("ap_available_cur", ap_available),
                SetVariable("MC_Strength_Cur", MC_Strength),
                SetVariable("MC_Dexterity_Cur", MC_Dexterity),
                SetVariable("MC_Magic_Cur", MC_Magic),
                SetVariable("MC_Willpower_Cur", MC_Willpower),
                SetVariable("MC_Cunning_Cur", MC_Cunning),
                SetVariable("MC_Body_Cur", MC_Body),


                SetVariable("tp_available_cur", tp_available),

                Show('profile_menu')
                ]
            #action Show('character_info')
            mouse 'pointer'
            

        if wear_armor == 'leather_1':

            imagebutton:
                idle "images/icons/inventory.png" at shrink_small
                hover im.MatrixColor('images/icons/inventory.png', im.matrix.brightness(0.2))
                action Show('inventory_start')
                #action Show('inventory_menu')
                mouse 'pointer'

        imagebutton:
            idle "images/icons/skills.png" at shrink_small
            hover im.MatrixColor('images/icons/skills.png', im.matrix.brightness(0.2))
            action Show('skills_window')
            mouse 'pointer'

        imagebutton:
            idle "images/icons/quests.png" at shrink_small
            hover im.MatrixColor('images/icons/quests.png', im.matrix.brightness(0.2))
            action Show('quest_menu')
            mouse 'pointer'


        # imagebutton:
        #     idle "images/icons/map.png" at shrink_small
        #     hover im.MatrixColor('images/icons/map.png', im.matrix.brightness(0.2))
        #     insensitive im.MatrixColor('images/icons/map.png', im.matrix.saturation(-1.0))
        #     sensitive can_open_map()
        #     action (Show('game_fantasy_map_village') if can_open_map() else NullAction())
        #     mouse 'pointer'


        imagebutton:
            idle "images/icons/map.png" at shrink_small
            hover im.MatrixColor('images/icons/map.png', im.matrix.brightness(0.2))
            insensitive im.MatrixColor("images/icons/map.png", im.matrix.desaturate() * im.matrix.brightness(-0.3))
            sensitive can_open_map()
            if game_stage >= 4:
                action (Show('game_fantasy_map_village') if can_open_map() else NullAction())
                mouse 'pointer'
            else:
                action NullAction()

        if game_stage >= 3:

            imagebutton:
                idle "images/icons/friends.png" at shrink_small
                hover im.MatrixColor('images/icons/friends.png', im.matrix.brightness(0.2))
                action Show('friend_list')
                mouse 'pointer'

        
        


default ui_block_map = False


init python:
    def can_open_map():
        # стадия игры
        if store.game_stage < 4:
            return False
        # глобальный флаг «занят»
        if getattr(store, "ui_block_map", False):
            return False
        # не открывать поверх активного say/choice/nvl
        if renpy.get_screen("say") or renpy.get_screen("choice") or renpy.get_screen("nvl"):
            return False
        return True






default alchemy_menu_available = 0

screen inventory_start:

    modal True

    add "images/character_menu/background.png"

    hbox xalign 0.5 yalign 0.5:

        spacing 120


        
        imagebutton:
            idle "images/inventory/inventory.png" at shrink3
            hover im.MatrixColor('images/inventory/inventory.png', im.matrix.brightness(0.1))
            action [
                Hide('inventory_start'),
                Show('inventory_menu')
            ]
            mouse 'pointer'



        if alchemy_menu_available:

            imagebutton:
                idle "images/inventory/alchemy.png" at shrink3
                hover im.MatrixColor('images/inventory/alchemy.png', im.matrix.brightness(0.1))
                action [
                    Hide('inventory_start'),
                    Show('alchemy_menu')
                ]
                mouse 'pointer'

            
        imagebutton:
            idle "images/inventory/archives_soon.png" at shrink3
            hover im.MatrixColor('images/inventory/archives.png', im.matrix.brightness(0.1))
            # action [
            #     Hide('inventory_start'),
            #     Show('alchemy_menu')
            # ]
            # mouse 'pointer'

    

    

    imagebutton xalign 0.998 yalign 0.01:
        idle "images/quests/buttons/exit.png"
        hover im.MatrixColor('images/quests/buttons/exit.png', im.matrix.brightness(0.2))
        mouse 'pointer'
        

        action [
            Hide('inventory_start')
        ]
        


    key "K_ESCAPE":

        action [
            Hide('inventory_start')
        ]




screen game_icons_blocked:

    modal True

    vbox xalign 1.0 yalign 0.5:
 
        imagebutton:
            idle "images/icons/char.png" at shrink_small
            hover im.MatrixColor('images/icons/char.png', im.matrix.brightness(0.2))
            action [
                SetVariable("ap_available_cur", ap_available),
                SetVariable("MC_Strength_Cur", MC_Strength),
                SetVariable("MC_Dexterity_Cur", MC_Dexterity),
                SetVariable("MC_Magic_Cur", MC_Magic),
                SetVariable("MC_Willpower_Cur", MC_Willpower),
                SetVariable("MC_Cunning_Cur", MC_Cunning),
                SetVariable("MC_Body_Cur", MC_Body),


                SetVariable("tp_available_cur", tp_available),
                Show('profile_menu')
                ]
            #action Show('character_info')
            mouse 'pointer'
            

        if wear_armor == 'leather_1':
            imagebutton:
                idle "images/icons/inventory.png" at shrink_small
                hover im.MatrixColor('images/icons/inventory.png', im.matrix.brightness(0.2))
                action Show('inventory_start')
                #action Show('inventory_menu')
                mouse 'pointer'

        imagebutton:
            idle "images/icons/skills.png" at shrink_small
            hover im.MatrixColor('images/icons/skills.png', im.matrix.brightness(0.2))
            action Show('skills_window')
            mouse 'pointer'

        imagebutton:
            idle "images/icons/quests.png" at shrink_small
            hover im.MatrixColor('images/icons/quests.png', im.matrix.brightness(0.2))
            action Show('quest_menu')
            mouse 'pointer'

        imagebutton:
            idle "images/icons/map.png" at shrink_small
            hover im.MatrixColor('images/icons/map.png', im.matrix.brightness(0.2))
            if game_stage >= 4:
                action Show('game_fantasy_map_village')
                mouse 'pointer'
            else:
                action NullAction()

        if game_stage >= 3:

            imagebutton:
                idle "images/icons/friends.png" at shrink_small
                hover im.MatrixColor('images/icons/friends.png', im.matrix.brightness(0.2))
                action Show('friend_list')
                mouse 'pointer'











screen clear_vision:

    imagebutton xalign 1.0 yalign 0.0:
        idle "images/eye.png"
        hover im.MatrixColor('images/eye.png', im.matrix.brightness(0.2))
        mouse 'pointer'
        action NullAction()


            


screen clear_vision_closed:

    modal True

    imagebutton xalign 1.0 yalign 0.0:
        idle "images/eye.png"
        hover im.MatrixColor('images/eye.png', im.matrix.brightness(0.2))
        mouse 'pointer'
        action Jump('Part3_15')



transform shrink_small:
    zoom 0.2
