default current_alchemy_category = 0


default selected_recipe = None


screen alchemy_menu:

    modal True

    add "images/alchemy/background.png"


    hbox xpos 10 ypos 20:

        spacing -10


        imagebutton:
            idle "images/alchemy/brewing.png"
            hover im.MatrixColor('images/alchemy/brewing.png', im.matrix.brightness(0.2))
            mouse 'pointer'
            
            action SetVariable('current_alchemy_category', 0)

        imagebutton:
            idle "images/alchemy/recipes.png"
            hover im.MatrixColor('images/alchemy/recipes.png', im.matrix.brightness(0.2))
            mouse 'pointer'
            
            action SetVariable('current_alchemy_category', 1)












    if current_alchemy_category == 0:

        if reagents_show == 1:

            window background None:
                area (40, 170, 650, 840)

                viewport:
                    mousewheel True
                    draggable True
                    pagekeys True
                    side_yfill True

                    vpgrid:
                        cols 4
                        spacing 5
                        xalign 0.5
                        yalign 0.0

                        for key, item in sorted(reagents.items(), key=lambda kv: kv[1].name):
                            if item.quantity > 0:
                                fixed:
                                    xsize 152
                                    ysize 152

                                    # Картинка делается кликабельной, чтобы работал hovered/unhovered
                                    imagebutton:
                                        idle Transform(item.image, fit=True, xsize=152, ysize=152)
                                        hover Transform(item.image, fit=True, xsize=152, ysize=152)
                                        hovered SetVariable("hovered_item", item)
                                        unhovered SetVariable("hovered_item", None)
                                        action [
                                            SetVariable('reagents_show', 0),
                                            SetVariable('main_reagent', item),
                                            SetVariable("hovered_item", None)
                                        ]
                                        mouse 'pointer'

                                    text "x[item.quantity]" font "gui/fonts/TMR_Regular.ttf" size 42 color "#fbd389" xalign .97 yalign 1.0 outlines [(2, "#000000", 0, 0)]







        




        if ingredients_show == 1:

            window background None:
                area (1240, 170, 650, 840)
                viewport:
                    #scrollbars "vertical"
                    mousewheel True
                    draggable True
                    pagekeys True
                    side_yfill True


                    vpgrid:
                        cols 4
                        spacing 5
                        xalign 0.5
                        yalign 0.0

                        # сортировка опциональна
                        for key, item in sorted(ingredients.items(), key=lambda kv: kv[1].name):
                            if item.quantity > 0:
                                fixed:
                                    xsize 152
                                    ysize 152

                                    imagebutton:
                                        idle Transform(item.image, fit=True, xsize=152, ysize=152)
                                        hover Transform(item.image, fit=True, xsize=152, ysize=152)
                                        hovered SetVariable("hovered_item", item)
                                        unhovered SetVariable("hovered_item", None)

                                        if main_ingredient_1 == None:
                                            action [
                                                SetVariable('ingredients_show', 0),
                                                SetVariable('main_ingredient_1', item),
                                                SetVariable("hovered_item", None)
                                            ]

                                        elif main_ingredient_2 == None:
                                            action [
                                                SetVariable('ingredients_show', 0),
                                                SetVariable('main_ingredient_2', item),
                                                SetVariable("hovered_item", None)
                                            ]

                                        elif main_ingredient_3 == None:
                                            action [
                                                SetVariable('ingredients_show', 0),
                                                SetVariable('main_ingredient_3', item),
                                                SetVariable("hovered_item", None)
                                            ]

                                        else:

                                            action NullAction()

                                        mouse 'pointer'

                                    # text item.name size 20 xalign 0.5
                                    text "x[item.quantity]" font "gui/fonts/TMR_Regular.ttf" size 42 color "#fbd389" xalign .97 yalign 1.0 outlines [(2, "#000000", 0, 0)]








        vbox xalign 0.5 ypos 160:

            spacing 30

            text "Primary Reagent" font "gui/fonts/TMR_Regular.ttf" size 42 color "#fbd389"


            if main_reagent != None:

                imagebutton xalign 0.5:

                    idle main_reagent.image
                    hover im.MatrixColor(main_reagent.image, im.matrix.brightness(0.2))
                    mouse 'pointer'
                    hovered SetVariable("hovered_item", main_reagent)
                    unhovered SetVariable("hovered_item", None)
                    
                    action [
                        SetVariable('main_reagent', None),
                        SetVariable('reagents_show', 1),
                        SetVariable("hovered_item", None)
                        ]

            else:

                imagebutton xalign 0.5:

                    idle "images/alchemy/add_btn.png"
                    hover im.MatrixColor('images/alchemy/add_btn.png', im.matrix.brightness(0.2))
                    mouse 'pointer'
                    
                    action SetVariable('reagents_show', 1)







        vbox xalign 0.5 ypos 480:

            spacing 30

            text "Ingredients" font "gui/fonts/TMR_Regular.ttf" size 42 color "#fbd389" xalign 0.5

            hbox xalign 0.5:
                
                spacing 20

                    
                if main_ingredient_1 != None:

                    imagebutton xalign 0.5:

                        idle main_ingredient_1.image
                        hover im.MatrixColor(main_ingredient_1.image, im.matrix.brightness(0.2))
                        mouse 'pointer'
                        hovered SetVariable("hovered_item", main_ingredient_1)
                        unhovered SetVariable("hovered_item", None)
                        
                        action [
                            SetVariable('main_ingredient_1', None),
                            SetVariable('ingredients_show', 1),
                            SetVariable("hovered_item", None)
                            ]


                if main_ingredient_2 != None:


                    imagebutton xalign 0.5:

                        idle main_ingredient_2.image
                        hover im.MatrixColor(main_ingredient_2.image, im.matrix.brightness(0.2))
                        mouse 'pointer'
                        hovered SetVariable("hovered_item", main_ingredient_2)
                        unhovered SetVariable("hovered_item", None)
                        
                        action [
                            SetVariable('main_ingredient_2', None),
                            SetVariable('ingredients_show', 1),
                            SetVariable("hovered_item", None)
                            ]



                if main_ingredient_3 != None:


                    imagebutton xalign 0.5:

                        idle main_ingredient_3.image
                        hover im.MatrixColor(main_ingredient_3.image, im.matrix.brightness(0.2))
                        mouse 'pointer'
                        hovered SetVariable("hovered_item", main_ingredient_3)
                        unhovered SetVariable("hovered_item", None)
                        
                        action [
                            SetVariable('main_ingredient_3', None),
                            SetVariable('ingredients_show', 1),
                            SetVariable("hovered_item", None)
                            ]



                if main_ingredient_3 != None and main_ingredient_2 != None and main_ingredient_1 != None:

                    pass

                else:

                    imagebutton xalign 0.5:

                        idle "images/alchemy/add_btn.png"
                        hover im.MatrixColor('images/alchemy/add_btn.png', im.matrix.brightness(0.2))
                        mouse 'pointer'
                        
                        action SetVariable('ingredients_show', 1)
                






                







        imagebutton xalign 0.5 ypos 860:
            idle "images/alchemy/brew_btn.png"
            hover im.MatrixColor('images/alchemy/brew_btn.png', im.matrix.brightness(0.2))
            mouse 'pointer'
            
            action Function(brew_current_selection)


        

        # ПОДКЛЮЧАЕМ ТУЛТИП ПОВЕРХ, если есть наведённый предмет
        if hovered_item:
            use item_tooltip(hovered_item)


    else:
        
        window background None:
            area (40, 150, 500, 840)
            viewport:
                scrollbars "vertical"
                mousewheel True
                draggable True
                pagekeys True
                side_yfill True


                vbox:

                    spacing 0
                    
                    for i in inventory_potions_recipes:

                        button:
                            mouse 'pointer'
                            xsize 470
                            ysize 90
                            action [
                                NullAction()
                            ]
                            hovered SetVariable("selected_recipe", i)
                            unhovered SetVariable("selected_recipe", None)

                            hbox xminimum 470:
                                hbox xalign 0.0:
                                    spacing 15
                                    yalign 0.5
                                    add i.image at shrink3, inventory_shrink_hovered yalign 0.5
                                    text i.name yalign 0.5 font "gui/fonts/Kurale.ttf" size 30 color "#9f9f9f" hover_color "#fff"

                                text "[inventory_potions_items.count(i)]{size=-4} 🧪" yalign 0.5 font "gui/fonts/Kurale.ttf" size 28 xalign 1.0 color "#fbd389"




        if selected_recipe is not None:

            $ pid = selected_recipe.id
            $ req = RECIPES_REQUIRED.get(pid, None)

            text "{size=+6}{b}[selected_recipe.name]{/b}{/size}\n\n[selected_recipe.desc]" xpos 730 ypos 160 xsize 1000 size 34 color "#c8a055" font "gui/fonts/TMR_Regular.ttf" text_align 0.5
            
            if req:
                
                hbox ypos 500 xpos 780:
                    spacing 220
                    # --- Primary Reagent (только картинка) ---
                    vbox:
                        spacing 40
                        text "Primary Reagent" font "gui/fonts/TMR_Regular.ttf" size 42 color "#fbd389" xalign 0.5

                        $ rkey = req["alcohol"]
                        $ ritem = reagents.get(rkey, None)
                        if ritem:
                            add Transform(ritem.image, fit=True, xsize=152, ysize=152) xalign 0.5

                    # --- Ingredients (только картинки; количество = повтор) ---
                    vbox:
                        spacing 40
                        text "Ingredients" font "gui/fonts/TMR_Regular.ttf" size 42 color "#fbd389" xalign 0.5

                        hbox xalign 0.5 spacing 20:
                            $ ing_dict = req.get("ingredients", {})
                            for ikey, need_qty in ing_dict.items():
                                $ it = ingredients.get(ikey, None)
                                if it:
                                    for _ in range(need_qty):
                                        add Transform(it.image, fit=True, xsize=152, ysize=152)














    imagebutton xalign 0.998 yalign 0.01:
        idle "images/quests/buttons/exit.png"
        hover im.MatrixColor('images/quests/buttons/exit.png', im.matrix.brightness(0.2))
        mouse 'pointer'
        
        if Quest_6.currentstep == 2 and potion_1 in inventory_potions_items:
            action [
                    Hide('alchemy_menu'),
                    Jump('Part_0_16_9')
                ]

        else:
            action [
                    Hide('alchemy_menu')
                ]
        


    key "K_ESCAPE":
        
        if Quest_6.currentstep == 2 and potion_1 in inventory_potions_items:
            action [
                    Hide('alchemy_menu'),
                    Jump('Part_0_16_9')
                ]

        else:
            action [
                    Hide('alchemy_menu')
                ]













screen item_tooltip(item):
    zorder 1000
    modal False  # окно не блокирует мышь

    # Таймер, который перезапускает экран и обновляет позицию курсора
    timer 0.04 repeat True action renpy.restart_interaction

    # Позиция мыши
    $ mx, my = renpy.get_mouse_pos()
    # Размер подсказки
    $ TW, TH = 390, 200
    # Границы экрана
    $ SW = config.screen_width
    $ SH = config.screen_height

    # Смещение «по умолчанию» от курсора
    $ dx = 16
    $ dy = 16

    # Автоперелом по X/Y, если не влазит
    # Автоперелом X
    if mx + dx + TW <= SW:
        $ tx = mx + dx
    else:
        $ tx = mx - TW + dx-5   # вместо mx - TW - dx

    # Автоперелом Y
    if my + dy + TH <= SH:
        $ ty = my + dy
    else:
        $ ty = my - TH + dy   # вместо my - TH - dy

    # На всякий случай ограничим диапазон
    $ tx = max(0, min(tx, SW - TW))
    $ ty = max(0, min(ty, SH - TH))

    window background None:
        area (tx, ty, TW, TH)

        # Если хочешь фон-картинки, раскомментируй:
        add "textbox_info.png"
        add "info_fon.png" xpos 5 ypos 2

        frame:
            style "item_tooltip_frame"
            xsize TW
            ysize TH

            vbox xalign 0.5 ypos 5:

                text item.name style "item_tooltip_title" xalign 0.5

                text item.desc xsize (TW - 20) size 20 color "#cfc7c7" xalign 0.5 ypos 20

                # Цена (золото/серебро/медь) с автоматическим форматированием:
                $ g, s, c = split_coins(item.cost)
                hbox ypos 40 xminimum 390:
                    
                    if g > 0:
                        hbox xalign 0.97:
                            spacing 5
                            text "[g]" size 20 color "#ffff00"
                            text "{image=money_small_1.png}"
                            text "[s]" size 20 color "#e0e0e0"
                            text "{image=money_small_2.png}"
                            text "[c]" size 20 color "#ff9900"
                            text "{image=money_small_3.png}"

                    elif s > 0:
                        hbox xalign 0.97:
                            spacing 5
                            text "[s]" size 20 color "#e0e0e0"
                            text "{image=money_small_2.png}"
                            text "[c]" size 20 color "#ff9900"
                            text "{image=money_small_3.png}"

                    else:
                        hbox xalign 0.97:
                            spacing 5
                            text "[c]" size 20 color "#ff9900"
                            text "{image=money_small_3.png}"




style item_tooltip_frame is frame:
    background None #Frame("#0008", 8, 8)  # полупрозрачный фон
    outlines [(1, "#000000", 0, 0)]
    xminimum 360
    yminimum 220

style item_tooltip_title is text:
    size 24
    color "#ffffff"
    outlines [(2, "#000000", 0, 0)]
    background None





# Определяем класс для ингредиентов
init python:
    class Ingredient:
        def __init__(self, name, image, cost=0, quantity=0, desc=""):
            self.name = name
            self.image = image
            self.cost = cost
            self.quantity = quantity
            self.desc = desc  # ✨ новое поле — описание

        def add(self, amount=1):
            self.quantity += amount

        def remove(self, amount=1):
            if self.quantity >= amount:
                self.quantity -= amount
            else:
                self.quantity = 0





    class Reagents:
        def __init__(self, name, image, cost=0, quantity=0, desc=""):
            self.name = name
            self.image = image
            self.cost = cost
            self.quantity = quantity
            self.desc = desc  # ✨ новое поле — описание


        def add(self, amount=1):
            self.quantity += amount

        def remove(self, amount=1):
            if self.quantity >= amount:
                self.quantity -= amount
            else:
                self.quantity = 0



    # Пример функций для добавления/удаления из инвентаря
    def add_ingredient(key, amount=1):
        if key in ingredients:
            ingredients[key].add(amount)
        elif key in reagents:
            reagents[key].add(amount)

    def remove_ingredient(key, amount=1):
        if key in ingredients:
            ingredients[key].remove(amount)
        elif key in reagents:
            reagents[key].remove(amount)





    def split_coins(cost: int):
        gold   = cost // 10000
        silver = (cost // 100) % 100
        copper = cost % 100
        return gold, silver, copper













    from collections import Counter

    # --- ВСПОМОГАТЕЛЬНОЕ ----------------------------------------------------

    def _key_by_value(dct, obj):
        """Вернуть ключ словаря по объекту-значению (реагент/ингредиент)."""
        for k, v in dct.items():
            if v is obj:
                return k
        return None

    def _selected_ingredient_keys_with_dups():
        """
        Собираем список КЛЮЧЕЙ выбранных ингредиентов с сохранением дублей:
        [plant_1, plant_1, plant_2], если один ингредиент выбран 2 раза.
        """
        from renpy import store
        keys = []
        for it in (store.main_ingredient_1,
                   store.main_ingredient_2,
                   store.main_ingredient_3):
            if it is not None:
                k = _key_by_value(store.ingredients, it)
                if k:
                    keys.append(k)
        return keys  # дубликаты сохраняем

    # --- РЕЦЕПТЫ ------------------------------------------------------------
    # 1) Health Potion:       alcohol_1 x1, plant_1 x2
    # 2) Love Potion:         alcohol_1 x1, plant_8 x2, plant_2 x1
    # 3) Greater Love Potion: alcohol_1 x1, plant_8 x1, plant_2 x2

    RECIPES_REQUIRED = {
        1: {"alcohol": "alcohol_1", "ingredients": {"plant_1": 2}},
        2: {"alcohol": "alcohol_1", "ingredients": {"plant_8": 2, "plant_2": 1}},
        3: {"alcohol": "alcohol_1", "ingredients": {"plant_8": 1, "plant_2": 2}},
    }

    # --- Сопоставление выбора с рецептом ------------------------------------
    def _match_recipe_by_counts(alcohol_key, ing_keys):
        """
        Сравниваем выбранный алкоголь и список ингредиентов с каждым рецептом.
        Возвращаем potion_id или None.
        """
        if not alcohol_key:
            return None

        sel_counter = Counter(ing_keys)

        for pid, req in RECIPES_REQUIRED.items():
            if req["alcohol"] != alcohol_key:
                continue
            need_counter = Counter(req["ingredients"])
            if sel_counter == need_counter:
                return pid
        return None

    # --- Проверка наличия в инвентаре ---------------------------------------
    def _have_enough_for_selected(alcohol_key, ing_keys):
        from renpy import store

        if not alcohol_key:
            return False, "Select a primary reagent."

        if alcohol_key != "alcohol_1":
            return False, "Wrong reagent: requires Alcohol."

        if alcohol_key not in store.reagents or store.reagents[alcohol_key].quantity < 1:
            return False, "You don't have enough Alcohol."

        if not ing_keys:
            return False, "Select ingredients."

        counts = Counter(ing_keys)
        for ik, need_qty in counts.items():
            have = store.ingredients.get(ik).quantity if ik in store.ingredients else 0
            if have < need_qty:
                return False, "Not enough ingredients."
        return True, ""

    # --- Доступ к зельям ----------------------------------------------------
    def get_potions():
        from renpy import store
        return {
            1: store.potion_1,
            2: store.potion_2,
            3: store.potion_3,
        }

    # --- Основной вызов с кнопки BREW ---------------------------------------
    def brew_current_selection():
        from renpy import store

        alcohol_key = _key_by_value(store.reagents, store.main_reagent)
        ing_keys = _selected_ingredient_keys_with_dups()

        # Проверка наличия
        ok, msg = _have_enough_for_selected(alcohol_key, ing_keys)
        if not ok:
            renpy.notify(msg)
            return

        # Сопоставление с рецептом
        potion_id = _match_recipe_by_counts(alcohol_key, ing_keys)
        if potion_id is None:
            renpy.notify("No known recipe for this combination.")
            return

        # Списание ресурсов
        store.reagents[alcohol_key].remove(1)
        for ik, need_qty in Counter(ing_keys).items():
            store.ingredients[ik].remove(need_qty)

        # Добавление зелья
        crafted = get_potions()[potion_id]
        store.inventory_potions_items.append(crafted)
        

        # Очистка выбора
        store.main_reagent = None
        store.main_ingredient_1 = None
        store.main_ingredient_2 = None
        store.main_ingredient_3 = None

        # уведомление
        renpy.notify(f"You have brewed: {crafted.name}")



        # 🔹 Проверка и обновление квеста
        try:
            if (potion_id == 2                                    # сварили potion_2
                and hasattr(store, "Quest_10")
                and getattr(store.Quest_10, "currentstep", None) == 1
                and hasattr(store, "side_quests_list")
                and store.Quest_10 in store.side_quests_list):

                renpy.notify("The quest has been updated!")
                store.ChangeTextInQuestList(
                    store.Quest_10,
                    store.side_quests_list,
                    (store.Quest_10.text or "") + "\n\nI brewed the potion. Now I need to return to the blacksmith."
                )
        except Exception as e:
            # чтобы неожиданные ошибки в квест-логике не ломали крафт
            renpy.log("Quest_10 update error: %r" % e)


            

        # 🔹 Проверка и обновление квеста
        try:
            if (potion_id == 3                                    # сварили potion_2
                and hasattr(store, "Quest_10")
                and getattr(store.Quest_10, "currentstep", None) == 3
                and hasattr(store, "side_quests_list")
                and store.Quest_10 in store.side_quests_list):

                renpy.notify("The quest has been updated!")
                store.ChangeTextInQuestList(
                    store.Quest_10,
                    store.side_quests_list,
                    (store.Quest_10.text or "") + "\n\nI brewed another potion. Now I need to return to the blacksmith."
                )
        except Exception as e:
            # чтобы неожиданные ошибки в квест-логике не ломали крафт
            renpy.log("Quest_10 update error: %r" % e)





    def add_recipe(potion_id, alcohol_key, ingredients_dict):
        from renpy import store
        store.RECIPES_REQUIRED[potion_id] = {
            "alcohol": alcohol_key,
            "ingredients": ingredients_dict
        }
        renpy.notify(f"Recipe for {potion_id} added!")






















default hovered_item = None  # сюда кладём объект Reagents/Ingredient при hover




default main_reagent = None


default main_ingredient_1 = None

default main_ingredient_2 = None

default main_ingredient_3 = None


default reagents_show = 0

default ingredients_show = 0



default reagents = {

    "alcohol_1": Reagents("Alcohol", "images/alchemy/alcohol.png", cost=30, quantity=0, 
                        desc="A transparent liquid with a sharp smell, burning the fingers at a touch."),
    "alcohol_2": Reagents("Blood of the Sky", "images/alchemy/alcohol_2.png", cost=2500, quantity=0, 
                        desc="A thick crimson-blue substance shimmering in the dark."),
}




default ingredients = {

    "plant_1": Ingredient("Sun Primrose", "images/alchemy/plant/plant_1.jpg", cost=5, quantity=2,
                        desc="Golden petals seem to glow from within even on a cloudy day."),
    "plant_2": Ingredient("Bloody Web", "images/alchemy/plant/plant_2.jpg", cost=10, quantity=0,
                        desc="Thin scarlet veins entwine its leaves like a net of living threads."),
    "plant_3": Ingredient("Fire Lily", "images/alchemy/plant/plant_3.jpg", cost=25, quantity=0,
                        desc="A blazing bud radiating dry warmth with a faint crackling sound."),
    "plant_4": Ingredient("Amethyst Chimer", "images/alchemy/plant/plant_4.jpg", cost=10, quantity=0,
                        desc="Purple petals emit a soft chime at the slightest movement of air."),
    "plant_5": Ingredient("Dragonheart Root", "images/alchemy/plant/plant_5.jpg", cost=100, quantity=0,
                        desc="A coarse root, its cut surface resembling a pattern of frozen veins."),
    "plant_6": Ingredient("Snow Veil", "images/alchemy/plant/plant_6.jpg", cost=50, quantity=0,
                        desc="Snow-white leaves chill the palm and leave a trace of frost."),
    "plant_7": Ingredient("Wolf Fang", "images/alchemy/plant/plant_7.jpg", cost=25, quantity=0,
                        desc="The fang of a defeated beast."),
    "plant_8": Ingredient("Red Wine", "images/alchemy/plant/plant_8.jpg", cost=75, quantity=0,
                        desc="A dark ruby liquid served in every tavern."),
}