default current_location = "Real"



screen music:
    if current_location == "tavern_1":
        on "show" action Function(play_music_once, "audio/tavern_music.mp3")
    elif current_location == "WE":
        on "show" action Function(play_music_once, "audio/fantasy_music.mp3")
    elif current_location == "Real":
        on "show" action Function(play_music_once, "audio/main_music.mp3")
    elif current_location == "Club":
        on "show" action Function(play_music_once, "audio/Real_Club_Music_1.mp3")





init python:
    import random

    FANTASY_LIST = [
        "audio/fantasy_music.mp3",
        "audio/Fantasy_Music_1.mp3",
        "audio/Fantasy_Music_2.mp3",
        "audio/Fantasy_Music_3.mp3",
        "audio/Fantasy_Music_4.mp3",
        "audio/Fantasy_Music_5.mp3",
        "audio/Fantasy_Music_6.mp3",
    ]

    REAL_LIST = [
        "audio/main_music.mp3",
        "audio/Real_Music_1.mp3",
        "audio/Real_Music_2.mp3",
        "audio/Real_Music_3.mp3",
        "audio/Real_Music_4.mp3",
        "audio/Real_Music_5.mp3",
        "audio/Real_Music_6.mp3",
        "audio/Real_Music_7.mp3",
        "audio/Real_Music_8.mp3",
    ]

    TAVERN_LIST = [
        "audio/tavern_music.mp3",
        "audio/Fantasy_Tavern_Music_1.mp3",
    ]

    CLUB_LIST = [
        "audio/Real_Club_Music_1.mp3",
        "audio/Real_Club_Music_2.mp3",
        "audio/Real_Club_Music_3.mp3",
        "audio/Real_Club_Music_4.mp3",
    ]

    SEED_TO_PLAYLIST = {
        "audio/fantasy_music.mp3": ("WE", FANTASY_LIST),
        "audio/main_music.mp3":    ("Real", REAL_LIST),
        "audio/tavern_music.mp3":  ("tavern_1", TAVERN_LIST),
        "audio/Real_Club_Music_1.mp3":  ("Club", CLUB_LIST),
    }

    if not hasattr(renpy.store, "current_playlist_key"):
        renpy.store.current_playlist_key = None

    def play_music_once(path):
        from renpy import store

        entry = SEED_TO_PLAYLIST.get(path, None)
        if entry:
            key, playlist = entry

            if store.current_playlist_key == key and renpy.music.get_playing("music"):
                return

            # создаём новый случайный порядок
            shuffled = playlist[:]
            random.shuffle(shuffled)

            renpy.music.play(
                shuffled,
                channel="music",
                loop=True,        # по кругу после окончания всего списка
                fadein=0.5,
                if_changed=True
            )
            store.current_playlist_key = key
            return

        # fallback для одиночного трека
        current = renpy.music.get_playing("music")
        if current != path:
            renpy.music.play(path, channel="music", loop=True)


