default current_inventory_category = 0




screen inventory_menu:

    modal True

    add "images/character_menu/background.png"
    
    if equipped_body != None:
        
        add "images/inventory/char/%d.png" % equipped_body.id xalign 0.94 yalign 0.5

    elif equipped_underwear != None:

        add "images/inventory/char/underwear/%d.png" % equipped_underwear.id xalign 0.94 yalign 0.5

    else:

        if game_mc_changed == 1:

            add "images/inventory/char/nude_2.png" xalign 0.94 yalign 0.5

        else:
            add "images/inventory/char/nude_1.png" xalign 0.94 yalign 0.5
    



    hbox xpos 80 ypos -10:
        spacing 10

        $ categories = [
            ("armor.png", 0),
            ("weapon.png", 1),
            ("under.png", 2),
            ("art.png", 3),
            ("alchemy_btn.png", 4),         
            ("quest.png", 5),
            ("trash.png", 6), 
        ]

        for img, idx in categories:
            $ y = -70 if current_inventory_category == idx else -140
            $ path = "images/inventory/" + img
            imagebutton ypos y:
                idle path
                hover im.MatrixColor(path, im.matrix.brightness(0.2))
                action SetVariable("current_inventory_category", idx)
                mouse "pointer"
    



    use inventory_items_menu

    vbox xalign 0.62 yalign 0.3:

        spacing 10


        imagebutton:
            idle (equipped_body.image if equipped_body else "images/inventory/null_armor.png")
            hover (im.MatrixColor(equipped_body.image, im.matrix.brightness(0.2))
                if equipped_body else im.MatrixColor("images/inventory/null_armor.png", im.matrix.brightness(0.2)))
            # action Function(unequip_body, equipped_body)
            action Function(renpy.notify, "I’m not going to undress. Don’t even think about it!")
            mouse 'pointer'



        
        imagebutton xpos 80:
            idle (equipped_weapon.image if equipped_weapon else "images/inventory/null_armor.png")
            hover (im.MatrixColor(equipped_weapon.image, im.matrix.brightness(0.2))
                if equipped_weapon else im.MatrixColor("images/inventory/null_armor.png", im.matrix.brightness(0.2)))
            action Function(unequip_body, equipped_weapon)
            mouse 'pointer'

            

        
        imagebutton:
            idle (equipped_underwear.image if equipped_underwear else "images/inventory/null_armor.png")
            hover (im.MatrixColor(equipped_underwear.image, im.matrix.brightness(0.2))
                if equipped_underwear else im.MatrixColor("images/inventory/null_armor.png", im.matrix.brightness(0.2)))
            # action Function(unequip_body, equipped_underwear)
            action Function(renpy.notify, "I’m not going to undress. Don’t even think about it!")
            mouse 'pointer'

        

        imagebutton xpos 80:
            idle (equipped_relic.image if equipped_relic else "images/inventory/null_armor.png")
            hover (im.MatrixColor(equipped_relic.image, im.matrix.brightness(0.2))
                if equipped_relic else im.MatrixColor("images/inventory/null_armor.png", im.matrix.brightness(0.2)))
            action Function(unequip_body, equipped_relic)
            mouse 'pointer'
        


        
        # imagebutton xpos 80:
        #     idle "images/inventory/null_armor.png"
        #     hover im.MatrixColor("images/inventory/null_armor.png", im.matrix.brightness(0.2))
        #     action NullAction()
        #     mouse 'pointer'

    



                

    hbox xpos 90 ypos 840:

        add "images/profile/delimeter.png"


    

    vbox xalign 0.06 ypos 840:

        vbox ypos 20 xpos 10: 
            spacing 8


                # === СТАТЫ ПРЕДМЕТА ===
            # здесь перебираем все характеристики объекта hovered_armor и выводим только ненулевые


            
            # === СТАТЫ ПРЕДМЕТА С ДЕЛЬТОЙ К НАДЕТОМУ ===
            if hovered_armor is not None:
                $ rows = _stat_rows(hovered_armor, "armor", equipped_body)
                for name, val, diff, em in rows:
                    $ col = _diff_color(diff)
                    hbox xminimum 530:
                        text "[name]" font "gui/fonts/TMR_Regular.ttf" size 26 color "#fbd389" yalign 0.5
                        # значение предмета
                        hbox xalign 1.0:
                            text "[val]" font "gui/fonts/TMR_Regular.ttf" size 24 color "#ae7e26" yalign 0.7
                            # дельта к надетому
                            text " ([_diff_text(diff)])" font "gui/fonts/TMR_Regular.ttf" size 24 color col yalign 0.7

            elif hovered_weapon is not None:
                $ rows = _stat_rows(hovered_weapon, "weapon", equipped_weapon)
                for name, val, diff, em in rows:
                    $ col = _diff_color(diff)
                    hbox xminimum 530:
                        text "[name]" font "gui/fonts/TMR_Regular.ttf" size 26 color "#fbd389" yalign 0.5
                        hbox xalign 1.0:
                            text "[val]" font "gui/fonts/TMR_Regular.ttf" size 24 color "#ae7e26" yalign 0.7
                            text " ([_diff_text(diff)])" font "gui/fonts/TMR_Regular.ttf" size 24 color col yalign 0.7

            elif hovered_underwear is not None:
                $ rows = _stat_rows(hovered_underwear, "underwear", equipped_underwear)
                for name, val, diff, em in rows:
                    $ col = _diff_color(diff)
                    hbox xminimum 530:
                        text "[name]" font "gui/fonts/TMR_Regular.ttf" size 26 color "#fbd389" yalign 0.5
                        hbox xalign 1.0:
                            text "[val]" font "gui/fonts/TMR_Regular.ttf" size 24 color "#ae7e26" yalign 0.7
                            text " ([_diff_text(diff)])" font "gui/fonts/TMR_Regular.ttf" size 24 color col yalign 0.7

            elif hovered_relic is not None:
                $ rows = _stat_rows(hovered_relic, "relic", equipped_relic)
                for name, val, diff, em in rows:
                    $ col = _diff_color(diff)
                    hbox xminimum 530:
                        text "[name]" font "gui/fonts/TMR_Regular.ttf" size 26 color "#fbd389" yalign 0.5
                        hbox xalign 1.0:
                            text "[val]" font "gui/fonts/TMR_Regular.ttf" size 24 color "#ae7e26" yalign 0.7
                            text " ([_diff_text(diff)])" font "gui/fonts/TMR_Regular.ttf" size 24 color col yalign 0.7
                            

            elif hovered_alchemy is not None:
                $ rows = _stat_rows(hovered_alchemy, "alchemy", equipped_alchemy)
                for name, val, diff, em in rows:
                    $ col = _diff_color(diff)
                    hbox xminimum 530:
                        text "[name]" font "gui/fonts/TMR_Regular.ttf" size 26 color "#fbd389" yalign 0.5
                        hbox xalign 1.0:
                            text "[val]" font "gui/fonts/TMR_Regular.ttf" size 24 color "#ae7e26" yalign 0.7
                            text " ([_diff_text(diff)])" font "gui/fonts/TMR_Regular.ttf" size 24 color col yalign 0.7
                            

            elif hovered_quest_items is not None:
                $ rows = _stat_rows(hovered_quest_items, "quest_item", equipped_quest)
                for name, disc in rows:
                    hbox xminimum 530:
                        text "[disc]" font "gui/fonts/TMR_Regular.ttf" size 26 color "#fbd389" yalign 0.7 xsize 520
                            #text " ([_diff_text(diff)])" font "gui/fonts/TMR_Regular.ttf" size 24 color col yalign 0.7



                            

            else:
                hbox xminimum 530:
                    text "Hover over the item to view its attributes" font "gui/fonts/TMR_Regular.ttf" size 26 color "#fbd389" yalign 0.5 xsize 530





    hbox xpos 750 ypos 840:

        add "images/profile/delimeter.png"

        add "images/profile/delimeter.png"



    hbox xalign 0.85 yalign 0.9:

        spacing 90

        vbox xalign 0.5:

            vbox ypos 20 xpos 10: 
                spacing 8

                hbox xminimum 280:

                    text "Defense" font "gui/fonts/TMR_Regular.ttf" size 26 color "#fbd389" yalign 0.5

                    text "[equipped_stats.defense]" font "gui/fonts/TMR_Regular.ttf" size 24 color "#ae7e26" yalign 0.7 xalign 1.0

                hbox xminimum 280:

                    text "M. Defense" font "gui/fonts/TMR_Regular.ttf" size 26 color "#fbd389" yalign 0.5

                    text "[equipped_stats.magic_defense]" font "gui/fonts/TMR_Regular.ttf" size 24 color "#ae7e26" yalign 0.7 xalign 1.0

                hbox xminimum 280:

                    text "Attack" font "gui/fonts/TMR_Regular.ttf" size 26 color "#fbd389" yalign 0.5

                    text "[equipped_stats.attack]" font "gui/fonts/TMR_Regular.ttf" size 24 color "#ae7e26" yalign 0.7 xalign 1.0

                hbox xminimum 280:

                    text "M. Attack" font "gui/fonts/TMR_Regular.ttf" size 26 color "#fbd389" yalign 0.5

                    text "[equipped_stats.magic_attack]" font "gui/fonts/TMR_Regular.ttf" size 24 color "#ae7e26" yalign 0.7 xalign 1.0



        vbox xalign 0.5:

            vbox ypos 20 xpos 10: 
                spacing 8

                hbox xminimum 280:

                    text "Strength" font "gui/fonts/TMR_Regular.ttf" size 26 color "#fbd389" yalign 0.5

                    text "[MC_Strength + equipped_stats.strength]" font "gui/fonts/TMR_Regular.ttf" size 24 color "#ae7e26" yalign 0.7 xalign 1.0

                hbox xminimum 280:

                    text "Dexterity" font "gui/fonts/TMR_Regular.ttf" size 26 color "#fbd389" yalign 0.5

                    text "[MC_Dexterity + equipped_stats.dexterity]" font "gui/fonts/TMR_Regular.ttf" size 24 color "#ae7e26" yalign 0.7 xalign 1.0

                hbox xminimum 280:

                    text "Cunning" font "gui/fonts/TMR_Regular.ttf" size 26 color "#fbd389" yalign 0.5

                    text "[MC_Cunning + equipped_stats.cunning]" font "gui/fonts/TMR_Regular.ttf" size 24 color "#ae7e26" yalign 0.7 xalign 1.0

                hbox xminimum 280:

                    text "Willpower" font "gui/fonts/TMR_Regular.ttf" size 26 color "#fbd389" yalign 0.5

                    text "[MC_Willpower + equipped_stats.willpower]" font "gui/fonts/TMR_Regular.ttf" size 24 color "#ae7e26" yalign 0.7 xalign 1.0



        vbox xalign 0.5:

            vbox ypos 20 xpos 10: 
                spacing 8

                hbox xminimum 280:

                    text "Body" font "gui/fonts/TMR_Regular.ttf" size 26 color "#fbd389" yalign 0.5

                    text "[MC_Body + equipped_stats.body]" font "gui/fonts/TMR_Regular.ttf" size 24 color "#ae7e26" yalign 0.7 xalign 1.0

                hbox xminimum 280:

                    text "Magic" font "gui/fonts/TMR_Regular.ttf" size 26 color "#fbd389" yalign 0.5

                    text "[MC_Magic + equipped_stats.magic]" font "gui/fonts/TMR_Regular.ttf" size 24 color "#ae7e26" yalign 0.7 xalign 1.0

                hbox xminimum 280:

                    text "Sexuality" font "gui/fonts/TMR_Regular.ttf" size 26 color "#fbd389" yalign 0.5

                    text "[MC_Sexuality + equipped_stats.sexuality]" font "gui/fonts/TMR_Regular.ttf" size 24 color "#ae7e26" yalign 0.7 xalign 1.0

                hbox xminimum 280:

                    text "Luck" font "gui/fonts/TMR_Regular.ttf" size 26 color "#fbd389" yalign 0.5

                    text "[MC_Luck + equipped_stats.luck]" font "gui/fonts/TMR_Regular.ttf" size 24 color "#ae7e26" yalign 0.7 xalign 1.0










    imagebutton xalign 0.998 yalign 0.01:
        idle "images/quests/buttons/exit.png"
        hover im.MatrixColor('images/quests/buttons/exit.png', im.matrix.brightness(0.2))
        mouse 'pointer'
        
        action [
                Hide('inventory_menu')
            ]
        


    key "K_ESCAPE":

        action [
                Hide('inventory_menu')
            ]








transform inventory_shrink_hovered:
    on idle:
        linear 0.15 zoom 1.0
    on hover:
        linear 0.15 zoom 1.1








default equipped_body = armor_2   # сюда будет сохраняться надетая броня
default equipped_weapon = None   # сюда будет сохраняться надетая броня
default equipped_underwear = None   # сюда будет сохраняться надетая броня
default equipped_relic = None   # сюда будет сохраняться надетая броня
default equipped_alchemy = None   # сюда будет сохраняться надетая броня
default equipped_quest = None   # сюда будет сохраняться надетая броня



default equipped_stats = Equipped_Stats_Class(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)






init python:

    class Equipped_Stats_Class:
        def __init__(self, id, attack, defense, magic_attack, magic_defense, body, magic, sexuality, luck, cunning, strength, dexterity, willpower):
            self.id = id
            self.attack = attack
            self.defense = defense
            self.magic_attack = magic_attack
            self.magic_defense = magic_defense
            self.body = body
            self.magic = magic
            self.sexuality = sexuality
            self.luck = luck
            self.cunning = cunning
            self.strength = strength
            self.dexterity = dexterity
            self.willpower = willpower

    


    def _stat_rows(obj, kind, equipped):
        """
        Возвращает список кортежей (label, value, diff, emoji)
        только для ненулевых характеристик объекта obj.
        diff = value - value_equipped
        """
        if not obj:
            return []

        if kind == "armor":
            table = [
                ("Defense",     "defense",        "🛡️"),
                ("M. Defense",  "magic_defense",  "✨🛡️"),
                ("Body",        "body",           "🧍"),
                ("Magic",       "magic",          "✨"),
                ("Sexuality",   "sexuality",      "💋"),
                ("Luck",        "luck",           "🍀"),
                ("Cunning",     "cunning",        "🦊"),
                ("Strength",    "strength",       "💪"),
                ("Dexterity",   "dexterity",      "🤹"),
                ("Willpower",   "willpower",      "🔥🧠"),
            ]
        elif kind == "weapon":
            table = [
                ("Attack",      "attack",         "⚔️"),
                ("M. Attack",   "magic_attack",   "🔮"),
                ("Body",        "body",           "🧍"),
                ("Magic",       "magic",          "✨"),
                ("Sexuality",   "sexuality",      "💋"),
                ("Luck",        "luck",           "🍀"),
                ("Cunning",     "cunning",        "🦊"),
                ("Strength",    "strength",       "💪"),
                ("Dexterity",   "dexterity",      "🤹"),
                ("Willpower",   "willpower",      "🔥🧠"),
            ]
        elif kind == "relic":
            table = [
                ("M. Attack",   "magic_attack",   "🔮"),
                ("M. Defense",  "magic_defense",  "✨🛡️"),
                ("Body",        "body",           "🧍"),
                ("Magic",       "magic",          "✨"),
                ("Sexuality",   "sexuality",      "💋"),
                ("Luck",        "luck",           "🍀"),
                ("Cunning",     "cunning",        "🦊"),
                ("Strength",    "strength",       "💪"),
                ("Dexterity",   "dexterity",      "🤹"),
                ("Willpower",   "willpower",      "🔥🧠"),
            ]
        elif kind == "alchemy":
            table = [
                ("M. Attack",   "magic_attack",   "🔮"),
                ("M. Defense",  "magic_defense",  "✨🛡️"),
                ("Defense",     "defense",        "🛡️"),
                ("M. Defense",  "magic_defense",  "✨🛡️"),
                ("Mana",       "mana",          "✨"),
                ("Desire",   "desire",      "💋"),
                ("Health",        "health",           "❤️"),
            ]
            
        elif kind == "quest_item":
            # Вернём то, что ждёт твой вывод: список из одной пары (name, disc)
            return [(obj.name, obj.disc)]

        else:  # underwear
            table = [
                ("M. Attack",   "magic_attack",   "🔮"),
                ("M. Defense",  "magic_defense",  "✨🛡️"),
                ("Body",        "body",           "🧍"),
                ("Magic",       "magic",          "✨"),
                ("Sexuality",   "sexuality",      "💋"),
                ("Luck",        "luck",           "🍀"),
                ("Cunning",     "cunning",        "🦊"),
                ("Strength",    "strength",       "💪"),
                ("Dexterity",   "dexterity",      "🤹"),
                ("Willpower",   "willpower",      "🔥🧠"),
            ]

        rows = []
        for label, attr, emoji in table:
            val = getattr(obj, attr, 0) or 0
            if val == 0:
                continue
            base = getattr(equipped, attr, 0) if equipped else 0
            diff = val - base
            rows.append((label, val, diff, emoji))
        return rows

    def _diff_color(diff):
        return "#49c56b" if diff > 0 else ("#e85b3a" if diff < 0 else "#9f9f9f")

    def _diff_text(diff):
        # "+3", "0", "-2"
        return ("+" if diff > 0 else "") + str(diff)






transform equip_slot_hover:
    on hover:
        linear 0.15 zoom 1.1
    on idle:
        linear 0.15 zoom 1.0



default hovered_armor = None        # экранная переменная для hover-предмета
default hovered_weapon = None        # экранная переменная для hover-предмета
default hovered_relic = None        # экранная переменная для hover-предмета
default hovered_underwear = None        # экранная переменная для hover-предмета
default hovered_alchemy = None        # экранная переменная для hover-предмета
default hovered_quest_items = None        # экранная переменная для hover-предмета




screen inventory_items_menu:

    window background None:
        area (85, 180, 600, 620)
        viewport:
            scrollbars "vertical"
            mousewheel True
            draggable True
            pagekeys True
            side_yfill True


            vbox:

                spacing 0

                if current_inventory_category == 0:
                
                    for i in inventory_armor_items:

                        button:
                            mouse 'pointer'
                            xsize 570
                            ysize 90
                            action [
                                Function(equip_body, i, 'equipped_body')
                            ]
                            hovered SetScreenVariable('hovered_armor', i)
                            unhovered SetScreenVariable('hovered_armor', None)

                            hbox xminimum 570:
                                hbox xalign 0.0:
                                    spacing 15
                                    yalign 0.5
                                    add i.image at shrink3, inventory_shrink_hovered yalign 0.5
                                    text i.name yalign 0.5 font "gui/fonts/Kurale.ttf" size 30 color "#9f9f9f" hover_color "#fff"

                                text "[i.defense] 🛡️" yalign 0.5 font "gui/fonts/Kurale.ttf" size 28 xalign 1.0 color "#2f89ff"



                elif current_inventory_category == 1:
                
                    for i in inventory_weapon_items:

                        button:
                            mouse 'pointer'
                            xsize 570
                            ysize 90
                            action [
                                Function(equip_body, i, 'equipped_weapon')
                            ]
                            hovered SetScreenVariable('hovered_weapon', i)
                            unhovered SetScreenVariable('hovered_weapon', None)

                            hbox xminimum 570:
                                hbox xalign 0.0:
                                    spacing 15
                                    yalign 0.5
                                    add i.image at shrink3, inventory_shrink_hovered yalign 0.5
                                    text i.name yalign 0.5 font "gui/fonts/Kurale.ttf" size 30 color "#9f9f9f" hover_color "#fff"

                                text "[i.attack] 🗡️" yalign 0.5 font "gui/fonts/Kurale.ttf" size 28 xalign 1.0 color "#2f89ff"



                elif current_inventory_category == 2:
                
                    for i in inventory_underwear_items:

                        button:
                            mouse 'pointer'
                            xsize 570
                            ysize 90
                            action [
                                Function(equip_body, i, 'equipped_underwear')
                            ]
                            hovered SetScreenVariable('hovered_underwear', i)
                            unhovered SetScreenVariable('hovered_underwear', None)

                            hbox xminimum 570:
                                hbox xalign 0.0:
                                    spacing 15
                                    yalign 0.5
                                    add i.image at shrink3, inventory_shrink_hovered yalign 0.5
                                    text i.name yalign 0.5 font "gui/fonts/Kurale.ttf" size 30 color "#9f9f9f" hover_color "#fff"

                                text "[i.sexuality] 💘" yalign 0.5 font "gui/fonts/Kurale.ttf" size 28 xalign 1.0 color "#2f89ff"



                elif current_inventory_category == 3:
                
                    for i in inventory_relic_items:

                        button:
                            mouse 'pointer'
                            xsize 570
                            ysize 90
                            action [
                                Function(equip_body, i, 'equipped_relic')
                            ]
                            hovered SetScreenVariable('hovered_relic', i)
                            unhovered SetScreenVariable('hovered_relic', None)

                            hbox xminimum 570:
                                hbox xalign 0.0:
                                    spacing 15
                                    yalign 0.5
                                    add i.image at shrink3, inventory_shrink_hovered yalign 0.5
                                    text i.name yalign 0.5 font "gui/fonts/Kurale.ttf" size 30 color "#9f9f9f" hover_color "#fff"

                                text "[i.magic] ✨" yalign 0.5 font "gui/fonts/Kurale.ttf" size 28 xalign 1.0 color "#2f89ff"

                




                elif current_inventory_category == 4:
                
                    for i in inventory_potions_items:

                        button:
                            mouse 'pointer'
                            xsize 570
                            ysize 90
                            action [
                                NullAction()
                            ]
                            hovered SetScreenVariable('hovered_alchemy', i)
                            unhovered SetScreenVariable('hovered_alchemy', None)

                            hbox xminimum 570:
                                hbox xalign 0.0:
                                    spacing 15
                                    yalign 0.5
                                    add i.image at shrink3, inventory_shrink_hovered yalign 0.5
                                    text i.name yalign 0.5 font "gui/fonts/Kurale.ttf" size 30 color "#9f9f9f" hover_color "#fff"

                                text "[inventory_potions_items.count(i)]{size=-4} 🧪" yalign 0.5 font "gui/fonts/Kurale.ttf" size 28 xalign 1.0 color "#2f89ff"

                




                elif current_inventory_category == 5:
                
                    for i in inventory_quest_items:

                        button:
                            mouse 'pointer'
                            xsize 570
                            ysize 90
                            action [
                                NullAction()
                            ]
                            hovered SetScreenVariable('hovered_quest_items', i)
                            unhovered SetScreenVariable('hovered_quest_items', None)

                            hbox xminimum 570:
                                hbox xalign 0.0:
                                    spacing 15
                                    yalign 0.5
                                    add i.image at shrink3, inventory_shrink_hovered yalign 0.5
                                    text i.name yalign 0.5 font "gui/fonts/Kurale.ttf" size 30 color "#9f9f9f" hover_color "#fff"

                                #text "[inventory_quest_items.count(i)]{size=-4} 🧪" yalign 0.5 font "gui/fonts/Kurale.ttf" size 28 xalign 1.0 color "#2f89ff"

                




