# === ПЕРЕМЕННЫЕ ===
default current_skills_menu = 0

# Warrior
default one_hand_exp = 0
default one_hand_lvl = 0
default two_hand_exp = 0
default two_hand_lvl = 0
default defense_exp = 0
default defense_lvl = 0

# Rogue
default rogue_weapon_exp = 0
default rogue_weapon_lvl = 0
default poison_exp = 0
default poison_lvl = 0
default shadow_exp = 0
default shadow_lvl = 0

# Mage
default magic_atk_exp = 0
default magic_atk_lvl = 0
default magic_def_exp = 0
default magic_def_lvl = 0
default mage_mastery_exp = 0
default mage_mastery_lvl = 0

# Wench
default seduce_exp = 0
default seduce_lvl = 0
default whore_exp = 0
default whore_lvl = 0
default love_exp = 0
default love_lvl = 0








# === Справочник описаний талантов ===
define skills_info = {
    "one_hand":   {"name": "One-Handed Weapons", "desc": "The skill of wielding swords, axes, and maces."},
    "two_hand":   {"name": "Two-Handed Weapons", "desc": "Powerful strikes with two-handed blades and axes."},
    "defense":    {"name": "Defense",            "desc": "Using shields and armor to block enemy attacks."},

    "weapon":     {"name": "Blades",             "desc": "Stealthy attacks with light weapons."},
    "poison":     {"name": "Poisons",            "desc": "Application of poisoned blades and potions."},
    "shadow":     {"name": "Shadow",             "desc": "The ability to merge with shadows and remain unseen."},

    "magic_atk":  {"name": "Offensive Magic",    "desc": "Destructive spells to eliminate enemies."},
    "magic_def":  {"name": "Defensive Magic",    "desc": "Shields, barriers, and protective spells."},
    "mage":       {"name": "Elemental Magic",     "desc": "Elemental spells to control air, fire, water, and earth."},

    "seduce":     {"name": "Seduction",          "desc": "Charming and alluring enemies or allies."},
    "whore":      {"name": "Whore",              "desc": "Using the body as a weapon and resource."},
    "love":       {"name": "Love",               "desc": "The power of passion and emotional bonds."}
}











# === Универсальный ряд таланта ===
screen skill_row(icon_path, exp_val, lvl_val, lvl_name, skill_id):

    if lvl_val > 0:
        hbox xpos 700 spacing 50:
            imagebutton:
                idle icon_path
                hover icon_path
                hovered Show("skill_tooltip", skill=skills_info[skill_id])
                unhovered Hide("skill_tooltip")
                action NullAction()
                yalign 0.5

            bar yalign 0.5:
                style "skills_bar"
                value exp_val
                range max(1, lvl_val * 98)
                left_bar "gui/scrollbar/horizontal_idle_skills.png"

            text "[lvl_val]" font "gui/fonts/Kurale.ttf" color "#fff" size 132 ypos -10 xpos 20
    else:
        hbox xpos 1100 spacing 20:
            imagebutton:
                idle icon_path
                hover icon_path
                hovered Show("skill_tooltip", skill=skills_info[skill_id])
                unhovered Hide("skill_tooltip")
                action NullAction()
                yalign 0.5 ysize 196

            imagebutton:
                yalign 0.5
                idle "images/skills_menu/add.png"
                hover im.MatrixColor('images/skills_menu/add.png', im.matrix.brightness(0.2))
                mouse "pointer"
                if sp_available > 0:
                    action [
                        SetVariable(lvl_name, 1),
                        SetVariable("sp_available", sp_available - 1)
                    ]
                else:
                    action Function(renpy.notify, "Not enough skill points to learn")





screen skill_tooltip(skill):
    zorder 1000
    modal False
    timer 0.04 repeat True action renpy.restart_interaction

    $ mx, my = renpy.get_mouse_pos()
    $ TW, TH = 380, 160
    $ SW, SH = config.screen_width, config.screen_height
    $ dx, dy = 16, 16

    $ tx = mx + dx if mx + dx + TW <= SW else mx - TW - dx
    $ ty = my + dy if my + dy + TH <= SH else my - TH - dy
    $ tx = max(0, min(tx, SW - TW))
    $ ty = max(0, min(ty, SH - TH))

    frame:

        add "textbox_info2.png"
        style "item_tooltip_frame"
        xpos tx
        ypos ty
        xsize TW
        ysize TH

        vbox xpos 4 ypos 2:
            spacing 6
            text skill["name"] size 30 style "item_tooltip_title" color "#c8a055" 
            text skill["desc"] size 24 color "#cfc7c7"







screen skills_window:

    modal True
    add "images/skills_menu/background.png"


    text "Available skill points: [sp_available]" font "gui/fonts/TMR.ttf" size 26 ypos 60 xpos 30 color "#c8a055"

    vbox xpos 80 yalign 0.5:
        spacing 30
        textbutton "Warrior" text_font "gui/fonts/TMR.ttf" text_size 62 mouse 'pointer' action SetVariable('current_skills_menu', 0) xalign 0.5
        textbutton "Rogue"   text_font "gui/fonts/TMR.ttf" text_size 62 mouse 'pointer' action SetVariable('current_skills_menu', 1) xalign 0.5
        textbutton "Mage"    text_font "gui/fonts/TMR.ttf" text_size 62 mouse 'pointer' action SetVariable('current_skills_menu', 2) xalign 0.5
        #textbutton "Wench"   text_font "gui/fonts/TMR.ttf" text_size 62 mouse 'pointer' action SetVariable('current_skills_menu', 3) xalign 0.5
        textbutton "Wench"   text_font "gui/fonts/TMR.ttf" text_size 62 mouse 'pointer' action NullAction() xalign 0.5 sensitive False

    vbox yalign 0.5:
        spacing 60

        if current_skills_menu == 0:
            use skill_row("images/skills_menu/one_hand.png", one_hand_exp, one_hand_lvl, "one_hand_lvl", "one_hand")
            use skill_row("images/skills_menu/two_hand.png", two_hand_exp, two_hand_lvl, "two_hand_lvl", "two_hand")
            use skill_row("images/skills_menu/defense.png",  defense_exp,  defense_lvl, "defense_lvl",  "defense")

        elif current_skills_menu == 1:
            use skill_row("images/skills_menu/weapon.png",  rogue_weapon_exp, rogue_weapon_lvl, "rogue_weapon_lvl", "weapon")
            use skill_row("images/skills_menu/poison.png",  poison_exp,       poison_lvl,       "poison_lvl",       "poison")
            use skill_row("images/skills_menu/shadow.png",  shadow_exp,       shadow_lvl,       "shadow_lvl",       "shadow")

        elif current_skills_menu == 2:
            use skill_row("images/skills_menu/magic_atk.png", magic_atk_exp,    magic_atk_lvl,    "magic_atk_lvl",    "magic_atk")
            use skill_row("images/skills_menu/magic_def.png", magic_def_exp,    magic_def_lvl,    "magic_def_lvl",    "magic_def")
            use skill_row("images/skills_menu/mage.png",      mage_mastery_exp, mage_mastery_lvl, "mage_mastery_lvl", "mage")

        elif current_skills_menu == 3:
            use skill_row("images/skills_menu/seduce.png", seduce_exp, seduce_lvl, "seduce_lvl", "seduce")
            use skill_row("images/skills_menu/whore.png",  whore_exp,  whore_lvl,  "whore_lvl",  "whore")
            use skill_row("images/skills_menu/love.png",   love_exp,   love_lvl,   "love_lvl",   "love")


    imagebutton xalign 0.998 yalign 0.01:
        idle "images/quests/buttons/exit.png"
        hover im.MatrixColor('images/quests/buttons/exit.png', im.matrix.brightness(0.2))
        mouse 'pointer'
        action [
            Hide('skills_window'),
            Hide('skill_tooltip')
            ]

    key "K_ESCAPE":
        action [
            Hide('skills_window'),
            Hide('skill_tooltip')
            ]


        